#ifndef _ReplicationDlg_CPP
#define _ReplicationDlg_CPP
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include <Windows.H>
#include <Stdio.H>
#include <Stdlib.H>
#include <CommCtrl.h>

#include "../Resources/Resource.H"

#include "../CSockSrvr/CSockSrvr.H"

#include "../Source/NSWFL.H"
#include "../Source/Entry.H"
#include "../Source/Routines.H"
#include "../Source/Replication.H"

#include "../Dialogs/MainDlg.H"
#include "../Dialogs/SplashDlg.H"
#include "../Dialogs/ReplicationDlg.H"
#include "../Dialogs/RepIssues.H"

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

//---------------------(Variable Declarations)
HWND Replication_hWnd = NULL;

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

BOOL CALLBACK ReplicationDialog(HWND xHandle, UINT xMessage, WPARAM wParam, LPARAM lParam)
{
    //--------------------------------------------------------------------------

	static HWND TablesList_hWnd = NULL;

    //--------------------------------------------------------------------------

    if(xMessage == WM_INITDIALOG)
    {
        Replication_hWnd = xHandle;

        SendMessage(xHandle, (UINT)WM_SETTEXT, (WPARAM)0, (LPARAM)gsTitleCaption);
        SendMessage(xHandle, WM_SETICON, TRUE, (LPARAM) LoadIcon(ghAppInstance, MAKEINTRESOURCE(IDI_TRAYICON)) );

		LV_COLUMN MyLVColumb;
		memset(&MyLVColumb, 0, sizeof(MyLVColumb));

		TablesList_hWnd = GetDlgItem(xHandle, IDC_TALBES);

        int iLVStyle = LVS_EX_GRIDLINES | LVS_EX_FULLROWSELECT | LVS_EX_CHECKBOXES;
        SendMessage(TablesList_hWnd, (UINT)LVM_SETEXTENDEDLISTVIEWSTYLE, (WPARAM)0, (LPARAM)iLVStyle);

        //SELECT Name, CrDate, RefDate FROM SysObjects WHERE xType = 'U'
			
		// Create Listview columbs
        MyLVColumb.cx        = 300;
        MyLVColumb.pszText   = "Table Name";
        MyLVColumb.iSubItem  = 0;
        MyLVColumb.mask      = LVCF_WIDTH | LVCF_TEXT | LVCF_SUBITEM;
        MyLVColumb.fmt       = LVCFMT_LEFT;
        ListView_InsertColumn(TablesList_hWnd, 0, &MyLVColumb);

        MyLVColumb.cx        = 150;
        MyLVColumb.pszText   = "Created Date";
        MyLVColumb.iSubItem  = 1;
        MyLVColumb.mask      = LVCF_WIDTH | LVCF_TEXT | LVCF_SUBITEM;
        MyLVColumb.fmt       = LVCFMT_LEFT;
        ListView_InsertColumn(TablesList_hWnd, 1, &MyLVColumb);

		PopTablesGrid(TablesList_hWnd);

		CenterWindow(xHandle);

        return TRUE;
    }

    //--------------------------------------------------------------------------

    if(xMessage == WM_COMMAND)
    {
		if(wParam == ID_REPISSUES)
        {
			DialogBox(ghAppInstance, MAKEINTRESOURCE(IDD_REPISSUES), xHandle, RepIssuesDialog);
			return TRUE;
		}

		if(wParam == ID_CHKALL)
        {
			CheckGridRows(TablesList_hWnd, true);
			return TRUE;
		}

        if(wParam == ID_CHKNONE)
        {
			CheckGridRows(TablesList_hWnd, false);
			return TRUE;
		}

		if(wParam == ID_OK)
        {
			if(ProcessTablesGrid(TablesList_hWnd))
			{
				EndDialog(xHandle,0);
				DestroyWindow(xHandle);
			}

			return TRUE;
        }

        if(wParam == ID_CANCEL)
        {
			EndDialog(xHandle,0);
			DestroyWindow(xHandle);
			return TRUE;
        }
		
		return FALSE;
    }

	//--------------------------------------------------------------------------

	if(xMessage == WM_PAINT)
    {
        HDC ThisHDC;
        PAINTSTRUCT ThisPS;

        ThisHDC = BeginPaint(xHandle, &ThisPS);

        // Any painting should be done here

        EndPaint(xHandle, &ThisPS);
        return TRUE;
    }

    //--------------------------------------------------------------------------

    if(xMessage == WM_CLOSE) 
    {
        EndDialog(xHandle,0);
        DestroyWindow(xHandle);
        return TRUE;
    }

    //--------------------------------------------------------------------------

    return FALSE;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void CheckGridRows(HWND TablesList_hWnd, bool bCheck)
{
	int iRow = 0;
	int iItems = ListView_GetItemCount(TablesList_hWnd);

	while(iRow < iItems)
    {
		ListView_SetCheckState(TablesList_hWnd, iRow, (BOOL) bCheck);
		iRow++;
	}
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool PopTablesGrid(HWND TablesList_hWnd)
{
	int iItem = 0;
	int iTempSz = 0;
	int iChecked = 0;

	char sTemp[1024];
	
	CSQL cSQL;
	CRecordSet rsTemp;
	
	LV_ITEM MyLVItem;
	memset(&MyLVItem, 0, sizeof(MyLVItem));

	if(!cSQL.Connect(gsSQLDriver, gsSQLServer, gsSQLUserID, gsSQLPassword, gsSQLDatabase))
	{
		MsgBox("Failed to connect to the SQL server.");
		return false;
	}

	strcpy(sTemp, "SELECT A.Name, A.CrDate, A.RefDate, Count(B.ID)"
		" FROM SysObjects AS A, SysObjects AS B"
		" WHERE A.xType = 'U' AND LEFT(A.NAME, 8) <> 'SQLExch_'"
		" AND A.ID *= B.Parent_Obj AND LEFT(B.NAME, 8) = 'SQLExch_'"
		" AND A.Name <> 'dtProperties'"
		//" AND A.ID IN (SELECT ID FROM SysColumns WHERE SysColumns.ColStat = 1)"
		" GROUP BY A.Name, A.CrDate, A.RefDate"
		" ORDER BY A.Name");

	cSQL.Execute(sTemp, &rsTemp);

	while(rsTemp.Fetch())
	{
		rsTemp.sColumnEx(1, sTemp, sizeof(sTemp), &iTempSz);
		MyLVItem.pszText = sTemp;
        MyLVItem.mask = LVIF_TEXT;
        MyLVItem.iSubItem = 0;
		MyLVItem.iItem = iItem;
        ListView_InsertItem(TablesList_hWnd, &MyLVItem);

		rsTemp.sColumnEx(2, sTemp, sizeof(sTemp), &iTempSz);
        MyLVItem.pszText = sTemp;
        MyLVItem.mask = LVIF_TEXT;
        MyLVItem.iSubItem = 1;
		MyLVItem.iItem = iItem;
        ListView_SetItem(TablesList_hWnd, &MyLVItem);

		if(rsTemp.lColumn(4) > 0)
		{
			ListView_SetCheckState(TablesList_hWnd, iItem, TRUE);
			iChecked = 1;
		}
		else{
			ListView_SetCheckState(TablesList_hWnd, iItem, FALSE);
			iChecked = 0;
		}

        MyLVItem.mask = LVIF_PARAM;
        MyLVItem.iSubItem = 0;
		MyLVItem.lParam = iChecked;
		MyLVItem.iItem = iItem;
        ListView_SetItem(TablesList_hWnd, &MyLVItem);

		iItem++;
	}

	cSQL.Disconnect();

	return true;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool ProcessTablesGrid(HWND TablesList_hWnd)
{
    int iRow = 0;
	int iParam = 0;
	int iItems = ListView_GetItemCount(TablesList_hWnd);
	char sTableName[1024];

	LV_ITEM MyLVItem;

	CSQL cSQL;

	if(!cSQL.Connect(gsSQLDriver, gsSQLServer, gsSQLUserID, gsSQLPassword, gsSQLDatabase))
	{
		MsgBox("Failed to connect to the SQL server.");
		return false;
	}

	while(iRow < iItems)
    {
        memset(&MyLVItem, 0, sizeof(MyLVItem));
		MyLVItem.cchTextMax = sizeof(sTableName);
		MyLVItem.pszText    = sTableName;
		MyLVItem.mask       = LVIF_PARAM|LVIF_TEXT;
        MyLVItem.iSubItem   = 0;
		MyLVItem.iItem      = iRow;

		if(ListView_GetItem(TablesList_hWnd, &MyLVItem))
		{
			iParam = MyLVItem.lParam;

			//If the item is checked.
			if(ListView_GetCheckState(TablesList_hWnd, iRow))
			{
				//If the item was previously unchecked.
				if(iParam == 0)
				{
					CreateReplication(&cSQL, gsReplicationDB, gsSQLDatabase, gsDefaultDBO, sTableName);
				}
			}
			else { //If the item is unchecked.

				//If the item was previously checked.
				if(iParam == 1)
				{
					DropReplicationTriggers(&cSQL, gsSQLDatabase, sTableName);
					DropReplicationTables(&cSQL, gsReplicationDB, gsSQLDatabase, gsDefaultDBO, sTableName);
				}
			}
		}
        iRow++;
    }

	GenerateReplicationScripts(&cSQL, gsReplicationDB, gsSQLDatabase, gsDefaultDBO);

	cSQL.Disconnect();

	return true;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#endif

